#include "openGLControl.h"

COpenGL33Control::COpenGL33Control()
{
}

COpenGL33Control::~COpenGL33Control()
{
}

bool COpenGL33Control::Init()
{
	// load files first

	bool Error = false;

	Error |= !ShaderProgram.Load("shader.vert", "shader.frag");

	if(Error)
	{
		return false;
	}

	// alocate memory for data

	float *Triangle = new float[6 * 3];
	float *Quad = new float[6 * 4];

	// init data

	int ti = 0;

	// x, y, z, r, g, b

	Triangle[ti++] = -0.4f; Triangle[ti++] =  0.1f; Triangle[ti++] =  0.0f; Triangle[ti++] = 1.0f; Triangle[ti++] = 0.0f; Triangle[ti++] = 0.0f;
	Triangle[ti++] =  0.4f; Triangle[ti++] =  0.1f; Triangle[ti++] =  0.0f; Triangle[ti++] = 0.0f; Triangle[ti++] = 1.0f; Triangle[ti++] = 0.0f;
	Triangle[ti++] =  0.0f; Triangle[ti++] =  0.7f; Triangle[ti++] =  0.0f; Triangle[ti++] = 0.0f; Triangle[ti++] = 0.0f; Triangle[ti++] = 1.0f;

	int qi = 0;

	// x, y, z, r, g, b

	Quad[qi++] = -0.2f; Quad[qi++] = -0.1f; Quad[qi++] = 0.0f; Quad[qi++] = 1.0f; Quad[qi++] = 0.0f; Quad[qi++] = 0.0f;
	Quad[qi++] = -0.2f; Quad[qi++] = -0.6f; Quad[qi++] = 0.0f; Quad[qi++] = 0.0f; Quad[qi++] = 1.0f; Quad[qi++] = 0.0f;
	Quad[qi++] =  0.2f; Quad[qi++] = -0.1f; Quad[qi++] = 0.0f; Quad[qi++] = 0.0f; Quad[qi++] = 0.0f; Quad[qi++] = 1.0f;
	Quad[qi++] =  0.2f; Quad[qi++] = -0.6f; Quad[qi++] = 0.0f; Quad[qi++] = 1.0f; Quad[qi++] = 1.0f; Quad[qi++] = 0.0f;

	// set up VBOs

	glGenBuffers(2, VBO);

	glBindBuffer(GL_ARRAY_BUFFER, VBO[0]);
	glBufferData(GL_ARRAY_BUFFER, 6 * 3 * sizeof(float), Triangle, GL_STATIC_DRAW);

	glBindBuffer(GL_ARRAY_BUFFER, VBO[1]);
	glBufferData(GL_ARRAY_BUFFER, 6 * 4 * sizeof(float), Quad, GL_STATIC_DRAW);

	glBindBuffer(GL_ARRAY_BUFFER, 0); // don't forget to unbind current VBO

	// free memory

	delete [] Triangle;
	delete [] Quad;

	// set up VAOs

	glGenVertexArrays(2, VAO);

	glBindVertexArray(VAO[0]);
	glBindBuffer(GL_ARRAY_BUFFER, VBO[0]);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 24, (void*)0);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 24, (void*)12);
	glEnableVertexAttribArray(1);

	glBindVertexArray(VAO[1]);
	glBindBuffer(GL_ARRAY_BUFFER, VBO[1]);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 24, (void*)0);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(1, 3, GL_FLOAT, GL_FALSE, 24, (void*)12);
	glEnableVertexAttribArray(1);

	glBindVertexArray(0); // don't forget to unbind current VAO

	return true;
}

void COpenGL33Control::Render(float FrameTime)
{
	// clear color buffer
	glClear(GL_COLOR_BUFFER_BIT);

	// bind program
	glUseProgram(ShaderProgram);

	// bind 1st VAO and draw
	glBindVertexArray(VAO[0]);
	glDrawArrays(GL_TRIANGLES, 0, 3);

	// bind 2nd VAO and draw
	glBindVertexArray(VAO[1]);
	glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

	// don't forget to unbind current VAO
	glBindVertexArray(0);

	// don't forget to unbind current program
	glUseProgram(0);
}

void COpenGL33Control::Resize(int Width, int Height)
{
	this->Width = Width;
	this->Height = Height;

	// set up viewport
	glViewport(0, 0, Width, Height);
}

void COpenGL33Control::Destroy()
{
	// destroy shader
	ShaderProgram.Destroy();
}
